import axios from "axios";

function baseUrl() {
  const host = process.env.WHM_HOST;
  const port = process.env.WHM_PORT || "2087";
  const ssl = (process.env.WHM_SSL || "true").toLowerCase() === "true";
  return `${ssl ? "https" : "http"}://${host}:${port}`;
}

function authHeader() {
  const user = process.env.WHM_USERNAME;
  const token = process.env.WHM_API_TOKEN;
  return `whm ${user}:${token}`;
}

export async function createCpanelAccount({ domain, username, password, email, pkg }) {
  const url = `${baseUrl()}/json-api/createacct`;
  const params = {
    "api.version": 1,
    domain,
    username,
    password,
    contactemail: email,
    pkgname: pkg
  };

  const res = await axios.get(url, {
    params,
    headers: { Authorization: authHeader() },
    timeout: 30000
  });

  return res.data;
}

export async function removeCpanelAccount({ username, keepdns = 0 }) {
  const url = `${baseUrl()}/json-api/removeacct`;
  const params = {
    "api.version": 1,
    username,
    keepdns: Number(keepdns || 0)
  };

  const res = await axios.get(url, {
    params,
    headers: { Authorization: authHeader() },
    timeout: 60000
  });

  return res.data;
}