const pkgSelect = document.getElementById("pkgSelect");
const packageCards = document.getElementById("packageCards");
const form = document.getElementById("orderForm");
const resultBox = document.getElementById("resultBox");
const submitBtn = document.getElementById("submitBtn");

document.getElementById("year").textContent = new Date().getFullYear();

function setResult(type, html) {
  resultBox.className = "result" + (type ? ` ${type}` : "");
  resultBox.innerHTML = html;
}

async function loadPackages() {
  const res = await fetch("/api/packages");
  const data = await res.json();
  if (!data.ok) throw new Error("Gagal ambil packages");

  pkgSelect.innerHTML = "";
  packageCards.innerHTML = "";

  data.packages.forEach((p) => {
    const opt = document.createElement("option");
    opt.value = p;
    opt.textContent = p;
    pkgSelect.appendChild(opt);

    const card = document.createElement("div");
    card.className = "card";
    card.innerHTML = `
      <div class="title">
        <span>${escapeHtml(p)}</span>
        <span class="pill">Package</span>
      </div>
      <ul>
        <li>Auto create cPanel via WHM</li>
        <li>Auto delete saat expired</li>
        <li>Output data cPanel lengkap</li>
      </ul>
    `;
    packageCards.appendChild(card);
  });
}

form.addEventListener("submit", async (e) => {
  e.preventDefault();
  setResult("", "Memproses… menghubungi WHM API…");
  submitBtn.disabled = true;

  const fd = new FormData(form);
  const payload = Object.fromEntries(fd.entries());

  try {
    const res = await fetch("/api/order", {
      method: "POST",
      headers: { "content-type": "application/json" },
      body: JSON.stringify({
        domain: (payload.domain || "").trim(),
        username: (payload.username || "").trim(),
        password: payload.password || "",
        email: (payload.email || "").trim(),
        pkg: payload.pkg,
        expire_date: payload.expire_date,
        keepdns: Number(payload.keepdns || 0)
      })
    });

    const data = await res.json();

    if (!data.ok) {
      setResult("bad", `❌ <b>Gagal</b>: ${escapeHtml(data.message || "Error")}<br/><small>Cek package, token, dan permission WHM.</small>`);
      return;
    }

    // Format output sesuai request kamu
    setResult("ok", `
      ✅ <b>Berhasil Create cPanel</b><br/><br/>
      <div style="line-height:1.75">
        domain: <b>${escapeHtml(data.cpanel.domain)}</b><br/>
        username: <b>${escapeHtml(data.cpanel.username)}</b><br/>
        password: <b>${escapeHtml(data.cpanel.password)}</b><br/>
        link cpanel : <b>${escapeHtml(data.cpanel.link)}</b><br/>
        expired: <b>${escapeHtml(data.expires_at)}</b>
      </div>
      <small>Catat password sekarang (tidak disimpan server).</small>
    `);

    form.reset();
  } catch (err) {
    setResult("bad", `❌ <b>Error</b>: ${escapeHtml(err.message || "Server error")}`);
  } finally {
    submitBtn.disabled = false;
  }
});

function escapeHtml(str) {
  return String(str)
    .replaceAll("&","&amp;")
    .replaceAll("<","&lt;")
    .replaceAll(">","&gt;")
    .replaceAll('"',"&quot;")
    .replaceAll("'","&#039;");
}

loadPackages().catch(() => {
  setResult("bad", "Gagal load packages. Pastikan backend jalan.");
});